<?php

require_once('tcpdf/tcpdf.php');

class PrintOrderPdf extends TCPDF
{
	public $date;

	public function __construct()
	{
		parent::__construct('P', PDF_UNIT, PDF_PAGE_FORMAT, true, 'utf-8', false);
		$this->date = date('d-m-Y H:i');

		$this->SetCreator(PDF_CREATOR);
		$this->SetAuthor('imaginalis.pl');

		$this->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));

		$this->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
		$this->SetFont('dejavusans', 'BI', 14, '', 'false');

		$this->SetMargins(25, 30, 25);

		$this->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE, PDF_HEADER_STRING);

		$this->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
		$this->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
		$this->SetHeaderMargin(PDF_MARGIN_HEADER);
		$this->SetFooterMargin(PDF_MARGIN_FOOTER);

		$this->SetAutoPageBreak(FALSE);

		$this->setImageScale(PDF_IMAGE_SCALE_RATIO);

		if (@file_exists(dirname(__FILE__).'/lang/eng.php')) {
				require_once(dirname(__FILE__).'/lang/eng.php');
				$this->setLanguageArray($l);
		}
	}

	public function Header()
	{
		$this->SetY(15);
		$this->SetFont('dejavusans', '', 10);
		$this->writeHTML('<table><tr>
				<td style="text-align:left">' . $this->title . '</td>
				<td style="text-align:right">Data: ' . $this->date . '</td>
			</tr></table><br><hr>');
	}

	public function Footer()
	{
		$this->SetY(-20);
		$this->SetFont('dejavusans', 'I', 10);
		$this->writeHTML('
			<table height="50">
			<tr>
				<td style="text-align:left"><img height="50" src="images/footer/logo-pokl.png"></td>
				<td style="text-align:center;line-height:5px"><div style="margin-left:25px">Strona ' . $this->getAliasNumPage() . ' / ' . $this->getAliasNbPages() . '</div></td>
				<td style="text-align:right"><img height="50" src="images/footer/logo-ue.png"></td>
			</tr>
			</table>
		');
	}
}
